package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.design.model.TestCase;

/**
 * TestCaseJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id TestCaseJsonUnmarshaller 2014-03-29 05:36:30z dungvnguyen $
 * @since 1.0
 */
public final class TestCaseJsonUnmarshaller extends AbstractUnmarshaller<TestCase, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static TestCaseJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static TestCaseJsonUnmarshaller getInstance() {
    if (instance == null) instance = new TestCaseJsonUnmarshaller();
    return instance;
  }

  @Override
  public TestCase parse(String data) throws Exception {
    return JsonMapper.parseJson(data, TestCase.class);
  }
}
