package org.qas.qtest.api.services.design.model.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.design.model.TestStep;

import java.util.List;

/**
 * ListTestStepJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ListTestStepJsonUnmarshaller 2014-04-04 06:31:30z dungvnguyen $
 * @since 1.0
 */
public class ListTestStepJsonUnmarshaller extends AbstractUnmarshaller<List<TestStep>, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static ListTestStepJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static ListTestStepJsonUnmarshaller getInstance() {
    if (instance == null) instance = new ListTestStepJsonUnmarshaller();
    return instance;
  }

  @Override
  public List<TestStep> parse(String data) throws Exception {
    return JsonMapper.parseJson(data, new TypeReference<List<TestStep>>() {
    });
  }
}
