package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.design.model.ListTestCaseRequest;

/**
 * ListTestCaseRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ListTestCaseRequestMarshaller 2014-04-25 16:40:30z dungvnguyen $
 * @since 1.0
 */
public final class ListTestCaseRequestMarshaller  extends AbstractTestCaseRequestMarshaller<ListTestCaseRequest> {
  //~ class properties ========================================================
  @Override
  public Request marshall(ListTestCaseRequest listTestCaseRequest) throws Exception {
    // validate test-case request.
    listTestCaseRequest = ApiPreconditions.notNull(listTestCaseRequest);
    validateProjectId(listTestCaseRequest.getProjectId());
    ApiPreconditions.checkArgument(
      listTestCaseRequest.getModuleId() == null || listTestCaseRequest.getModuleId().longValue() > 0,
      "Invalid module identifier passed to marshall(...)"
    );

    // create request.
    Request request = createJsonRequest(listTestCaseRequest, "ListTestCase", HttpMethod.GET);

    // set resource.
    if (listTestCaseRequest.getModuleId() == null) {
      request.setResourcePath(createApiPathBuilder(listTestCaseRequest.getProjectId()).toString());
    } else {
      StringBuilder pathBuilder = new StringBuilder(createApiBasePathWithProject(listTestCaseRequest.getProjectId()));
      pathBuilder.append("/test-cases");
      request.setResourcePath(pathBuilder.toString());

      // add request parameter.
      request.addParameter("parentId", String.valueOf(listTestCaseRequest.getModuleId()));
    }

    if (listTestCaseRequest.getPage() != null && listTestCaseRequest.getPage() > 0) {
      request.addParameter("page", String.valueOf(listTestCaseRequest.getPage().longValue()));
    }

    if (listTestCaseRequest.getPageSize() != null && listTestCaseRequest.getPageSize() > 0) {
      request.addParameter("size", String.valueOf(listTestCaseRequest.getPageSize().longValue()));
    }

    return request;
  }
}
