package org.qas.qtest.api.services.design.model.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.design.model.TestCase;

import java.util.List;

/**
 * ListTestCaseJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ListTestCaseJsonUnmarshaller 2014-04-25 16:45:30z dungvnguyen $
 * @since 1.0
 */
public class ListTestCaseJsonUnmarshaller extends AbstractUnmarshaller<List<TestCase>, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static ListTestCaseJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static ListTestCaseJsonUnmarshaller getInstance() {
    if (instance == null) instance = new ListTestCaseJsonUnmarshaller();
    return instance;
  }

  @Override
  public List<TestCase> parse(String data) throws Exception {
    return JsonMapper.parseJson(data, new TypeReference<List<TestCase>>() {
    });
  }
}
