package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.design.model.GetTestCaseRequest;

/**
 * GetTestCaseRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id GetTestCaseRequestMarshaller 2014-04-03 17:28:30z dungvnguyen $
 * @since 1.0
 */
public final class GetTestCaseRequestMarshaller extends AbstractTestCaseRequestMarshaller<GetTestCaseRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(GetTestCaseRequest testCaseRequest) throws Exception {
    // validate test-case request.
    testCaseRequest = ApiPreconditions.notNull(testCaseRequest);
    validateProjectId(testCaseRequest.getProjectId());
    validateTestCaseId(testCaseRequest.getTestCaseId());

    // create request.
    Request request = createJsonRequest(testCaseRequest, "GetTestCase", HttpMethod.GET);
    StringBuilder pathBuilder = new StringBuilder(createApiBasePathWithProject(testCaseRequest.getProjectId()));
    pathBuilder.append("/test-cases/").append(testCaseRequest.getTestCaseId().longValue());

    // add request parameter.
    if (testCaseRequest.getTestCaseVersion() != null && testCaseRequest.getTestCaseVersion() > 0) {
      request.addParameter("versionId", String.valueOf(testCaseRequest.getTestCaseVersion().longValue()));
    }

    // include test-steps?
    if (testCaseRequest.isIncludeTeststeps()) {
      request.addParameter("expand", "teststep");
    }

    // set resource path.
    request.setResourcePath(pathBuilder.toString());
    return request;
  }
}
