package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.design.model.DeleteTestCaseRequest;

/**
 * DeleteTestCaseRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id DeleteTestCaseRequestMarshaller 2015-06-03 17:15:30z dzungvnguyen $
 * @since 1.0
 */
public final class DeleteTestCaseRequestMarshaller
  extends AbstractTestCaseRequestMarshaller<DeleteTestCaseRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(DeleteTestCaseRequest testCaseRequest) throws Exception {
    // validate test-case.
    testCaseRequest = ApiPreconditions.notNull(testCaseRequest);
    validateProjectId(testCaseRequest.getProjectId());
    validateTestCaseId(testCaseRequest.getTestCaseId());

    // create request instance.
    Request request = createJsonRequest(testCaseRequest, "DeleteTestCase", HttpMethod.DELETE);

    // set request resource path.
    StringBuilder pathBuilder = new StringBuilder(createApiBasePathWithProject(testCaseRequest.getProjectId()));
    pathBuilder.append("/test-cases/").append(testCaseRequest.getTestCaseId());
    request.setResourcePath(pathBuilder.toString());

    return request;
  }
}
