package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.design.model.CreateTestCaseRequest;

/**
 * CreateTestCaseRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id CreateTestCaseRequestMarshaller 2014-04-04 09:46:30z dungvnguyen $
 * @since 1.0
 */
public final class CreateTestCaseRequestMarshaller extends AbstractTestCaseRequestMarshaller<CreateTestCaseRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(CreateTestCaseRequest testCaseRequest) throws Exception {
    testCaseRequest = ApiPreconditions.notNull(testCaseRequest);
    validateProjectId(testCaseRequest.getProjectId());
    ApiPreconditions.notNull(testCaseRequest.getTestCase(), "Invalid test-case instance passed to marshall(...)");

    // create request.
    Request request = createJsonRequest(testCaseRequest, "CreateTestCase", HttpMethod.POST);

    // build the path resource.
    StringBuilder pathBuilder = new StringBuilder(createApiBasePathWithProject(testCaseRequest.getProjectId()));
    pathBuilder.append("/test-cases");

    // set resource path.
    request.setResourcePath(pathBuilder.toString());

    // set body request.
    request.setContent(new StringInputStream(JsonMapper.toJson(testCaseRequest.getTestCase())));
    return request;
  }
}
