package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.design.model.ApproveTestCaseRequest;

/**
 * ApproveTestCaseRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ApproveTestCaseRequestMarshaller 2016-06-22 22:14:30z dzungvnguyen $
 * @since 1.0
 */
public class ApproveTestCaseRequestMarshaller extends AbstractTestCaseRequestMarshaller<ApproveTestCaseRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(ApproveTestCaseRequest testCaseRequest) throws Exception {
    // validate test-case.
    testCaseRequest = ApiPreconditions.notNull(testCaseRequest);
    validateProjectId(testCaseRequest.getProjectId());
    validateTestCaseId(testCaseRequest.getTestCaseId());

    // create request instance.
    Request request = createJsonRequest(testCaseRequest, "ApproveTestCase", HttpMethod.PUT);

    // set request resource path.
    StringBuilder pathBuilder = new StringBuilder(createApiBasePathWithProject(testCaseRequest.getProjectId()));
    pathBuilder.append("/test-cases/").append(testCaseRequest.getTestCaseId()).append("/approve");
    request.setResourcePath(pathBuilder.toString());

    return request;
  }
}
