package org.qas.qtest.api.services.design.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * UpdateTestCaseRequest
 *
 * @author Dzung Nguyen
 * @version $Id UpdateTestCaseRequest 2015-06-03 17:24:30z dzungvnguyen $
 * @since 1.0
 */
public class UpdateTestCaseRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long testCaseId;
  private TestCase testCase;

  //~ class members ===========================================================

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return this
   */
  public UpdateTestCaseRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test case identifier.
   */
  public Long getTestCaseId() {
    return testCaseId;
  }

  /**
   * Sets the test case identifier.
   *
   * @param testCaseId the given test case identifier to set.
   */
  public void setTestCaseId(Long testCaseId) {
    this.testCaseId = testCaseId;
  }

  /**
   * Sets the test case identifier.
   *
   * @param testCaseId the given test case identifier to set.
   * @return this
   */
  public UpdateTestCaseRequest withTestCaseId(Long testCaseId) {
    setTestCaseId(testCaseId);
    return this;
  }

  /**
   * @return current test-case instance.
   */
  public TestCase getTestCase() {
    return testCase;
  }

  /**
   * Sets the test-case instance.
   *
   * @param testCase the given test-case instance to set.
   */
  public void setTestCase(TestCase testCase) {
    this.testCase = testCase;
  }

  /**
   * Sets the test-case instance.
   *
   * @param testCase the given test-case instance to set.
   * @return this
   */
  public UpdateTestCaseRequest withTestCase(TestCase testCase) {
    setTestCase(testCase);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("UpdateTestCaseRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", testCaseId=").append(testCaseId);
    sb.append(", testCase=").append(testCase);
    sb.append('}');
    return sb.toString();
  }
}
