package org.qas.qtest.api.services.design.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * CreateTestCaseRequest
 *
 * @author Dzung Nguyen
 * @version $Id CreateTestCaseRequest 2014-04-04 09:31:30z dungvnguyen $
 * @since 1.0
 */
public class CreateTestCaseRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private TestCase testCase;

  //~ class members ===========================================================
  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the {@link CreateTestCaseRequest} instance.
   */
  public CreateTestCaseRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the {@link TestCase} instance.
   */
  public TestCase getTestCase() {
    return testCase;
  }

  /**
   * Sets the {@link TestCase} instance.
   *
   * @param testCase the given {@link TestCase} instance to set.
   */
  public void setTestCase(TestCase testCase) {
    this.testCase = testCase;
  }

  /**
   * Sets the {@link TestCase} instance.
   *
   * @param testCase the given {@link TestCase} instance to set.
   * @return the {@link CreateTestCaseRequest} instance.
   */
  public CreateTestCaseRequest withTestCase(TestCase testCase) {
    setTestCase(testCase);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("CreateTestCaseRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", testCase=").append(testCase);
    sb.append('}');
    return sb.toString();
  }
}
