package org.qas.qtest.api.services.design.model;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * AutomationTestCase
 *
 * @author Thong Nguyen
 * @version $Id AutomationTestCase 2015-03-14 22:47:30z thongnguyen $
 * @since 1.0
 */
public class AutomationTestCase extends TestCase {
  @JsonProperty("automation_content")
  private String automationContent;

  public AutomationTestCase() {
  }

  /**
   * Sets the automation content.
   *
   * @param automationContent the given automation contnet to set.
   * @return this
   */
  public AutomationTestCase setAutomationContent(String automationContent) {
    this.automationContent = automationContent;
    return this;
  }

  /**
   * @return the automation content.
   */
  public String getAutomationContent() {
    return automationContent;
  }

  /**
   * Sets the automation content.
   *
   * @param automationContent the given automation content.
   * @return the given automation test instance.
   */
  public AutomationTestCase withAutomationContent(String automationContent) {
    setAutomationContent(automationContent);
    return this;
  }
}
