package org.qas.qtest.api.services.defect.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.defect.model.Defect;

/**
 * DefectJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id DefectJsonUnmarshaller 2014-07-16 17:12:30z dungvnguyen $
 * @since 1.0
 */
public class DefectJsonUnmarshaller extends AbstractUnmarshaller<Defect, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static DefectJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static DefectJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new DefectJsonUnmarshaller();
    }

    return instance;
  }

  @Override
  public Defect parse(String data) throws Exception {
    return JsonMapper.parseJson(data, Defect.class);
  }
}
