package org.qas.qtest.api.services.client.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.client.model.SetSessionUrlRequest;

/**
 * SetSessionUrlRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id SetSessionUrlRequestMarshaller 2015-01-13 14:06:30z dzungvnguyen $
 * @since 1.0
 */
public final class SetSessionUrlRequestMarshaller extends AbstractMarshaller<Request, SetSessionUrlRequest> {

  @Override
  protected void validateRequest(SetSessionUrlRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid argument passed to call(...)");
    }

    if (in.getSessionUrl() == null || "".equals(in.getSessionUrl())) {
      throw new AuthClientException("Invalid session URL value passed to call(...)");
    }
  }

  @Override
  protected void build(Request request, SetSessionUrlRequest in) {
    request.setHttpMethod(HttpMethod.PUT);
  }

  @Override
  protected String getServiceName() {
    return "ClientService";
  }

  @Override
  protected String getActionName() {
    return "SetSessionUrl";
  }

  @Override
  protected String getContent(SetSessionUrlRequest in) throws Exception {
    return new JsonObject().put("explorer_api_url", in.getSessionUrl()).toString();
  }

  @Override
  protected StringBuilder getResourcePath(SetSessionUrlRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/v3/explorer-api");
  }
}
