package org.qas.qtest.api.services.client.model;

import org.qas.api.ApiServiceRequest;

/**
 * GetClientRequest
 *
 * @author Dzung Nguyen
 * @version $Id GetClientRequest 2014-11-11 14:04:30z dungvnguyen $
 * @since 1.0
 */
public final class GetClientRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long clientId;

  //~ class members ===========================================================
  /**
   * @return the client identifier.
   */
  public Long getClientId() {
    return clientId;
  }

  /**
   * Sets the client identifier.
   *
   * @param clientId the given client identifier to set.
   */
  public void setClientId(Long clientId) {
    this.clientId = clientId;
  }

  /**
   * Sets the client identifier.
   *
   * @param clientId the given client identifier to set.
   * @return the current request instance.
   */
  public GetClientRequest withClientId(Long clientId) {
    setClientId(clientId);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("GetClientRequest{\n");
    sb.append("\tclientId: ").append(clientId).append("\n");
    sb.append('}');

    return sb.toString();
  }
}
