package org.qas.qtest.api.services.authenticate.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.authenticate.model.OAuthTokenResponse;

/**
 * OAuthTokenResponseJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id OAuthTokenResponseJsonUnmarshaller 2016-11-29 06:45:30z dzungvnguyen $
 * @since 1.0
 */
public final class OAuthTokenResponseJsonUnmarshaller extends AbstractUnmarshaller<OAuthTokenResponse, JsonUnmarshallerContext> {
  //~ class instance ==========================================================
  private static OAuthTokenResponseJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static OAuthTokenResponseJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new OAuthTokenResponseJsonUnmarshaller();
    }

    return instance;
  }

  @Override
  public OAuthTokenResponse parse(String data) throws Exception {
    return JsonMapper.parseJson(data, OAuthTokenResponse.class);
  }
}
