package org.qas.qtest.api.services.authenticate.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.google.net.HttpHeaders;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.authenticate.model.OAuthTokenRefreshRequest;

import static org.qas.qtest.api.services.authenticate.model.transform.OAuthAuthenticateRequestMarshaller.normalizeToken;

/**
 * OAuthTokenRefreshRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id OAuthTokenRefreshRequestMarshaller 2016-11-29 06:37:30z dzungvnguyen $
 * @since 1.0
 */
public class OAuthTokenRefreshRequestMarshaller extends AbstractMarshaller<Request, OAuthTokenRefreshRequest> {

  @Override
  protected void validateRequest(OAuthTokenRefreshRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid argument passed to call (...)");
    }
  }

  @Override
  protected void build(Request request, OAuthTokenRefreshRequest in) {
    request.setHttpMethod(HttpMethod.POST);
    request.setHeader(HttpHeaders.AUTHORIZATION, normalizeToken(in.getToken(), "Bearer"));
  }

  @Override
  protected String getServiceName() {
    return "AuthenticateService";
  }

  @Override
  protected String getActionName() {
    return "TokenRefresh";
  }

  @Override
  protected String getContent(OAuthTokenRefreshRequest in) throws Exception {
    return null;
  }

  @Override
  protected StringBuilder getResourcePath(OAuthTokenRefreshRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/oauth/refresh");
  }
}
