package org.qas.qtest.api.services.authenticate.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.google.net.HttpHeaders;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.authenticate.model.AuthenticateRequest;

/**
 * AuthenticateRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id AuthenticateRequestMarshaller 2014-07-09 10:32:30z dungvnguyen $
 * @since 1.0
 */
public class AuthenticateRequestMarshaller extends AbstractMarshaller<Request, AuthenticateRequest> {

  @Override
  protected void validateRequest(AuthenticateRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid argument passed to call (...)");
    }

    if (in.getUsername() == null) {
      throw new AuthClientException("Invalid username argument passed to call (...)");
    }

    if (in.getPassword() == null) {
      throw new AuthClientException("Invalid password argument passed to call (...)");
    }
  }

  @Override
  protected void build(Request request, AuthenticateRequest in) {
    request.setHeader(HttpHeaders.CONTENT_TYPE, "application/x-www-form-urlencoded");

    // set method and resource.
    request.setHttpMethod(HttpMethod.POST);

    // set request parameter.
    request.addParameter("j_username", in.getUsername());
    request.addParameter("j_password", in.getPassword());
  }

  @Override
  protected String getServiceName() {
    return "AuthenticateService";
  }

  @Override
  protected String getActionName() {
    return "Authenticate";
  }

  @Override
  protected String getContent(AuthenticateRequest in) throws Exception {
    return null;
  }

  @Override
  protected StringBuilder getResourcePath(AuthenticateRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/login");
  }
}
