package org.qas.qtest.api.services.attachment.model;

/**
 * AttachmentType
 *
 * @author Dzung Nguyen
 * @version $Id AttachmentType 2014-05-19 21:28:30z dungvnguyen $
 * @since 1.0
 */
public enum AttachmentType {
  //~ class members ===========================================================
  TESTCASE("test-cases"),
  REQUIREMENT("requirements"),
  DEFECT("defects"),
  TESTSTEP("test-steps"),
  TESTLOG("test-logs"),
  RELEASE("releases"),
  BUILD("builds");

  //~ class properties ========================================================
  private final String resourcePath;
  AttachmentType(String resourcePath) {
    this.resourcePath = resourcePath;
  }

  /**
   * @return the resource path of attachments (test-cases, requirements, defects, test-steps, test-logs)
   */
  public String getResourcePath() {
    return resourcePath;
  }
}
