package org.qas.qtest.api.services.attachment;

import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.QTestApiWebServiceClient;
import org.qas.qtest.api.services.attachment.model.Attachment;
import org.qas.qtest.api.services.attachment.model.AttachmentRequest;
import org.qas.qtest.api.services.attachment.model.transform.AttachmentJsonUnmarshaller;
import org.qas.qtest.api.services.attachment.model.transform.AttachmentRequestMarshaller;

/**
 * AttachmentServiceClient
 *
 * @author Dzung Nguyen
 * @version $Id AttachmentServiceClient 2014-05-19 17:13:30z dungvnguyen $
 * @since 1.0
 */
public class AttachmentServiceClient extends QTestApiWebServiceClient<AttachmentServiceClient>
    implements AttachmentService {

  /**
   * Constructs a new client to invoke service method on AttachmentService using
   * the default qTest credentials provider and default client configuration options.
   */
  public AttachmentServiceClient() {
    this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration());
  }

  /**
   * Constructs a new client to invoke service method on AttachmentService using
   * the default qTest credentials provider and client configuration options.
   *
   * @param clientConfiguration The client configuration options controlling how this
   *                            client connects to RequirementService
   */
  public AttachmentServiceClient(ClientConfiguration clientConfiguration) {
    this(new DefaultQTestCredentialsProviderChain(), clientConfiguration);
  }

  /**
   * Constructs a new client to invoke service method on AttachmentService using
   * the specified qTest credentials.
   *
   * @param credentials The qTest credentials which will provide
   *                    credentials to authenticate request with qTest services.
   */
  public AttachmentServiceClient(QTestCredentials credentials) {
    this(credentials, new ClientConfiguration());
  }

  /**
   * Constructs a new client to invoke service method on AttachmentService using
   * the specified qTest credentials and client configuration options.
   *
   * @param credentials The qTest credentials which will provide
   *                    credentials to authenticate request with qTest services.
   * @param clientConfiguration The client configuration options controlling how this
   *                            client connects to RequirementService
   */
  public AttachmentServiceClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
    super(clientConfiguration);
    this.credentialsProvider = new StaticQTestCredentialsProvider(credentials);
    init();
  }

  /**
   * Constructs a new client to invoke service method on AttachmentService using
   * the specified qTest credentials provider and client configuration options.
   *
   * @param credentialsProvider The qTest credentials provider which will provide
   *                            credentials to authenticate request with qTest services.
   */
  public AttachmentServiceClient(QTestCredentialsProvider credentialsProvider) {
    this(credentialsProvider, new ClientConfiguration());
  }

  /**
   * Constructs a new client to invoke service method on AttachmentService using
   * the specified qTest credentials provider and client configuration options.
   *
   * @param credentialsProvider The qTest credentials provider which will provide
   *                            credentials to authenticate request with qTest services.
   * @param clientConfiguration The client configuration options controlling how this
   *                            client connects to RequirementService
   */
  public AttachmentServiceClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
    super(clientConfiguration);
    this.credentialsProvider = credentialsProvider;

    init();
  }

  //~ implements methods ======================================================
  @Override
  public Attachment attach(AttachmentRequest attachmentRequest) throws AuthServiceException {
    try {
      Request request = new AttachmentRequestMarshaller().marshall(attachmentRequest);
      return invoke(request, AttachmentJsonUnmarshaller.getInstance());
    } catch (Exception ex) {
      Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
      throw new AuthClientException("An error occurs during attach data to qTest service", ex);
    }
  }
}
