package org.qas.qtest.api.services.attachment;

import org.qas.api.AuthClientException;
import org.qas.api.handler.AsyncHandler;
import org.qas.qtest.api.services.attachment.model.Attachment;
import org.qas.qtest.api.services.attachment.model.AttachmentRequest;

import java.util.concurrent.Future;

/**
 * AttachmentServiceAsync
 *
 * @author Dzung Nguyen
 * @version $Id AttachmentServiceAsync 2014-05-19 17:19:30z dungvnguyen $
 * @since 1.0
 */
public interface AttachmentServiceAsync extends AttachmentService {
  /**
   * Attachs the attach data.
   *
   * @param attachmentRequest the given attachment request data.
   * @return the attachment data.
   * @throws AuthClientException if an error occurs during attach data.
   */
  Future<Attachment> attachAsync(AttachmentRequest attachmentRequest) throws AuthClientException;

  /**
   * Attachs the attach data.
   *
   * @param attachmentRequest the given attachment request data.
   * @param asyncHandler callback handler for events in the life-cycle of the request.
   *                     Users could provide the implementation of the for callback
   *                     methods in this interface to process the operation result or
   *                     handle the exception.
   * @return the attachment data.
   * @throws AuthClientException if an error occurs during attach data.
   */
  Future<Attachment> attachAsync(AttachmentRequest attachmentRequest,
                                 AsyncHandler<AttachmentRequest, Attachment> asyncHandler) throws AuthClientException;
}
