package org.qas.qtest.api.internal.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.qas.api.internal.PropertyContainer;

/**
 * FieldValue
 *
 * @author Dzung Nguyen
 * @version $Id FieldValue 2014-05-18 20:23:30z dungvnguyen $
 * @since 1.0
 */
public class FieldValue extends PropertyContainer {

  @JsonProperty("field_id")
  private Long id;

  @JsonProperty("field_value")
  private String value;

  /**
   * Creates {@link FieldValue} instance.
   */
  public FieldValue() {
  }

  /**
   * Creates {@link FieldValue} instance from id and its value.
   *
   * @param id    the given field id.
   * @param value the given field value.
   */
  public FieldValue(Long id, String value) {
    setId(id);
    setValue(value);
  }

  /**
   * @return the field identifier.
   */
  public Long getId() {
    return id;
  }

  /**
   * Sets the field identifier.
   *
   * @param id the given field identifier to set.
   * @return the current instance.
   */
  public FieldValue setId(Long id) {
    this.id = id;
    return this;
  }

  /**
   * Sets the field identifier and return itself.
   *
   * @param id the given field identifier to set.
   * @return the current field value instance.
   */
  public FieldValue withId(Long id) {
    setId(id);
    return this;
  }

  /**
   * @return the field value.
   */
  public String getValue() {
    return value;
  }

  /**
   * Sets the field value.
   *
   * @param value the given field value to set.
   * @return the current instance.
   */
  public FieldValue setValue(String value) {
    this.value = value;
    return this;
  }

  /**
   * Sets the field value.
   *
   * @param value the given field value to set.
   * @return the field value instance.
   */
  public FieldValue withValue(String value) {
    setValue(value);
    return this;
  }

  @Override
  public FieldValue clone() {
    FieldValue that = new FieldValue();
    that.setPropertiesFrom(this);
    return that;
  }

  @Override
  public String elementName() {
    return "field-value";
  }
}
