package org.qas.qtest.api.internal.model;

import org.qas.api.ApiServiceRequest;

/**
 * AbstractQTestApiServiceRequest
 *
 * @author Dzung Nguyen
 * @version $Id AbstractQTestApiServiceRequest 2015-05-28 15:13:30z dzungvnguyen $
 * @since 1.0
 */
public abstract class AbstractQTestApiServiceRequest<T extends AbstractQTestApiServiceRequest> extends ApiServiceRequest {
  //~ class properties ========================================================
  protected Long projectId;

  //~ class members ===========================================================
  /**
   * @return the project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }
}
