package org.qas.qtest.api.auth;

import org.qas.api.AuthClientException;

/**
 * SystemPropertiesQTestCredentialsProvider
 *
 * @author Dzung Nguyen
 * @version $Id SystemPropertiesQTestCredentialsProvider 2014-03-27 13:29:30z dungvnguyen $
 * @since 1.0
 */
public class SystemPropertiesQTestCredentialsProvider implements QTestCredentialsProvider {
  //~ class properties ========================================================
  private static final String TOKEN_PROPERTY = "qTest.token";

  //~ class members ===========================================================
  public QTestCredentials getCredentials() {
    if (System.getProperty(TOKEN_PROPERTY) != null) {
      return new BasicQTestCredentials(System.getProperty(TOKEN_PROPERTY));
    }

    throw new AuthClientException("Unable to load qTest authentication token from Java system properties "
        + "(" + TOKEN_PROPERTY + ")");
  }

  public void refresh() {}

  @Override
  public String toString() {
    return getClass().getSimpleName();
  }
}
