package org.qas.qtest.api.auth;

import java.io.*;
import java.util.Properties;

/**
 * PropertiesQTestCredentials
 *
 * @author Dzung Nguyen
 * @version $Id PropertiesQTestCredentials 2014-03-27 12:28:30z dungvnguyen $
 * @since 1.0
 */
public class PropertiesQTestCredentials implements QTestCredentials {
  //~ class properties ========================================================
  private final String token;

  //~ class members ===========================================================
  /**
   * Reads the specified file as a Java properties file and extracts the
   * qTest authentication token. If the specified file doesn't
   * contain the qTest authentication token an IOException will be thrown.
   *
   * @param file
   *            The file from which to read the qTest credentials
   *            properties.
   *
   * @throws FileNotFoundException
   *             If the specified file isn't found.
   * @throws IOException
   *             If any problems are encountered reading the qTest authentication
   *             token from the specified file.
   * @throws IllegalArgumentException
   *             If the specified properties file does not contain the
   *             required token.
   */
  public PropertiesQTestCredentials(File file) throws IOException,
      IllegalArgumentException {
    if (!file.exists()) {
      throw new FileNotFoundException("File doesn't exist:  " + file.getAbsolutePath());
    }

    Properties properties = new Properties();
    properties.load(new FileInputStream(file));

    // read variable from stream.
    if (properties.getProperty("token") == null) {
      throw new IllegalArgumentException("The specified properties data" +
          "doesn't contain the expected properties 'token'.");
    }

    token = properties.getProperty("token");
  }

  /**
   * Reads the specified input stream as a stream of Java properties file
   * content and extracts the qTest authentication token from the properties.
   *
   * @param inputStream
   *            The input stream containing the qTest credential properties.
   *
   * @throws IOException
   *             If any problems occur while reading from the input stream.
   */
  public PropertiesQTestCredentials(InputStream inputStream) throws IOException {
    Properties properties = new Properties();

    // load the stream.
    try {
      properties.load(inputStream);
    } finally {
      try { inputStream.close(); } catch (Exception ex) {}
    }

    // read variable from stream.
    if (properties.getProperty("token") == null) {
      throw new IllegalArgumentException("The specified properties data" +
          "doesn't contain the expected properties 'token'.");
    }

    token = properties.getProperty("token");
  }

  public String getToken() {
    return token;
  }
}
