package org.qas.api.support;

import static org.qas.api.internal.util.Https.toQueryElement;
import static org.qas.api.internal.util.Https.toHeaderElement;

import org.qas.api.internal.util.google.base.Objects;

import java.util.Comparator;
import java.util.Map;

/**
 * Parameter
 *
 * @author Dzung Nguyen
 * @version $Id Parameter 2014-03-27 10:41:30z dungvnguyen $
 * @since 1.0
 */
public final class Parameter implements Map.Entry<String, String>, Comparator<Parameter> {
  //~ class properties ========================================================
  private final String key;
  private String value;

  //~ class members ===========================================================
  /**
   * Creates {@link Parameter} object from the given key.
   *
   * @param key String key to set.
   */
  public Parameter(String key) {
    this(key, null);
  }

  /**
   * Creates {@link Parameter parameter} object from the given key and it's value.
   *
   * @param key String key to set.
   * @param value String value to set.
   */
  public Parameter(String key, String value) {
    this.key = key;
    this.value = value;
  }

  @Override
  public String getKey() {
    return key;
  }

  @Override
  public String getValue() {
    return value;
  }

  @Override
  public String setValue(String s) {
    try {
      return value;
    } finally {
      this.value = s;
    }
  }

  @Override
  public int hashCode() {
    return Objects.hashCode(key, value);
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) return true;
    if (obj == null || !(obj instanceof Parameter)) return false;

    final Parameter that = (Parameter) obj;
    return Objects.equal(key, that.key) && Objects.equal(value, that.value);
  }

  @Override
  public int compare(Parameter p1, Parameter p2) {
    return p1.toString().compareTo(p2.toString());
  }

  @Override
  public String toString() {
    return toStringAsHeader();
  }

  /**
   * @return the parameter as query element format.
   */
  public String toStringAsQuery() {
    return toQueryElement(key, value);
  }

  /**
   * @return the parameter as header element format.
   */
  public String toStringAsHeader() {
    return toHeaderElement(key, value);
  }
}
