package org.qas.api.internal.util.key;

/**
 * UniqueKeyFactory
 *
 * @author Dzung Nguyen
 * @version $Id UniqueKeyFactory 2014-03-27 14:00:30z dungvnguyen $
 * @since 1.0
 */
public abstract class UniqueKeyFactory {
  /**
   * @return the new {@link UniqueKey} object.
   */
  public abstract UniqueKey generate();

  /**
   * Import the key from the source value.
   *
   * @param source the given key as string.
   * @return the {@link UniqueKey} instance.
   * @throws UniqueKeyException if an error during importing the key.
   */
  public abstract UniqueKey from(String source) throws UniqueKeyException;

  /**
   * Import the key from the source value.
   *
   * @param source the given key as bytes array.
   * @return the {@link UniqueKey} instance.
   * @throws UniqueKeyException if an error during importing the key.
   */
  public abstract UniqueKey from(byte[] source) throws UniqueKeyException;
}
