package org.qas.api.internal.util.key;

import org.qas.api.AuthClientException;

/**
 * UniqueKeyException
 *
 * @author Dzung Nguyen
 * @version $Id UniqueKeyException 2014-03-27 14:01:30z dungvnguyen $
 * @since 1.0
 */
public abstract class UniqueKeyException extends AuthClientException {
  //~ class properties ========================================================
  private static final long serialVersionUID = 6341428543840421188L;

  //~ class members ===========================================================
  /**
   * Creates {@link UniqueKeyException} object from the exception message.
   *
   * @param msg the given exception message.
   */
  protected UniqueKeyException(String msg) {
    super(msg);
  }

  /**
   * Creates {@link UniqueKeyException} object from the exception message and
   * the cause of exception.
   *
   * @param msg the given exception message.
   * @param cause the cause of exception.
   */
  protected UniqueKeyException(String msg, Throwable cause) {
    super(msg, cause);
  }
}
