package org.qas.api.internal.util;

import org.qas.api.internal.util.key.UniqueKey;
import org.qas.api.internal.util.key.UniqueKeyException;
import org.qas.api.internal.util.key.UniqueKeyFactory;
import org.qas.api.internal.util.key.support.MachineKeyFactory;

/**
 * UniqueKeys
 *
 * @author Dzung Nguyen
 * @version $Id UniqueKeys 2014-03-27 14:16:30z dungvnguyen $
 * @since 1.0
 */
public class UniqueKeys {
  //~ class properties ========================================================
  private static final UniqueKeyFactory UKEY_FACTORY = new MachineKeyFactory();

  //~ class members ===========================================================
  private UniqueKeys() {
    throw new AssertionError("The UniqueKeys utilities must not be instantiated.");
  }

  /**
   * Generates the unique key.
   *
   * @return the {@link UniqueKey} object.
   * @throws UniqueKeyException if an error occurs during generate key.
   */
  public static UniqueKey generate() throws UniqueKeyException {
    return UKEY_FACTORY.generate();
  }

  /**
   * @return the nonce value.
   */
  public static String generateNonce() {
    return UKEY_FACTORY.generate().toString();
  }
}
