package org.qas.api.internal.util;

import org.qas.api.internal.util.google.base.Charsets;

import java.io.ByteArrayInputStream;

/**
 * StringInputStream
 *
 * @author Dzung Nguyen
 * @version $Id StringInputStream 2014-03-27 15:08:30z dungvnguyen $
 * @since 1.0
 */
public class StringInputStream extends ByteArrayInputStream {
  //~ class properties ========================================================
  private final String string;

  //~ clas members ============================================================
  public StringInputStream(String string) {
    super(string.getBytes(Charsets.UTF_8));
    this.string = string;
  }

  public String getString() {
    return string;
  }
}
