package org.qas.api.http;

/**
 * Protocol
 *
 * @author: Dzung Nguyen
 * @version: $Id Protocol 2014-03-26 14:49:30z dungvnguyen $
 * @since 1.0
 */
public enum Protocol {
  /**
   * HTTP protocol - Using the HTTP protocol is less secure than HTTPS, but can
   * slightly reduce the system resources used when communicating with the
   * target server.
   */
  HTTP("http"),

  /**
   * HTTPS protocol - Using the HTTPS protocol is more secure than HTTP, but
   * may use slightly more system resources.
   */
  HTTPS("https");

  //~ class members ===========================================================
  private final String protocol;

  Protocol(String protocol) {
    this.protocol = protocol;
  }

  @Override
  public String toString() {
    return protocol;
  }
}
