package org.qas.api.http;

import org.qas.api.ApiServiceResponse;
import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.Request;

/**
 * HttpAuthClient
 *
 * @author: Dzung Nguyen
 * @version: $Id HttpAuthClient 2014-03-26 15:41:30z dungvnguyen $
 * @since 1.0
 */
public interface HttpAuthClient<T> {
  /**
   * Executes the request and return the response.
   *
   * @param request the request to send to the server.
   * @param context Additional information about the context of this web
   *                service call.
   * @return the response object.
   * @throws org.qas.api.AuthClientException if an error occurs during executing the request.
   * @throws org.qas.api.AuthServiceException if an error occurs during executing the request.
   */
  HttpResponse<T> execute(Request request, ExecutionContext context)
      throws AuthClientException;
  /**
   * Executes the request and return the response.
   *
   * @param request the request to send to server.
   * @param responseHandler the response handler to accept a successful response
   *                        from the remote server.
   * @param errorResponseHandler A response handler to accept an unsuccessful
   *                             response from the remote server.
   * @param context Additional information about the context of this web service
   *                call.
   * @return the response object.
   * @throws AuthClientException if an error occurs during executing the request.
   * @throws AuthServiceException if an error occurs during executing the request.
   */
  <V> V execute(Request request,
                HttpResponseHandler<ApiServiceResponse<V>> responseHandler,
                HttpResponseHandler<AuthServiceException> errorResponseHandler,
                ExecutionContext context) throws AuthClientException;

  /**
   * Shuts down and releases the connection to server.
   */
  void shutdown();
}
