package org.qas.api.http;

import java.io.IOException;

/**
 * AbstractHttpResponse
 *
 * @author Dzung Nguyen
 * @version $Id AbstractHttpResponse 2014-03-27 11:47:30z dungvnguyen $
 * @since 1.0
 */
public abstract class AbstractHttpResponse<T> implements HttpResponse<T> {
  //~ class members ===========================================================
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("<http-response>\n");

    try {
      builder.append("\t<code>").append(getStatusCode()).append("</code>\n");
      builder.append("\t<status>").append(getStatus()).append("</status>\n");
    } catch (IOException ex) {}

    builder.append("\t<headers>").append(getHeaders().toString()).append("</headers>\n");
    builder.append("</http-response>");

    return builder.toString();
  }
}
