package org.qas.api.handler;

import org.qas.api.Request;

/**
 * RequestHandler
 *
 * @author: Dzung Nguyen
 * @version: $Id RequestHandler 2014-03-26 15:31:30z dungvnguyen $
 * @since 1.0
 */
public interface RequestHandler {
  /**
   * Runs any additional processing logic on the specified request.
   *
   * @param request the low level request being processed.
   */
  void beforeRequest(Request request);

  /**
   * Runs any additional processing logic on the specified request.
   *
   * @param request the low level request being processed.
   * @param response the response generated from the specified request.
   */
  void afterResponse(Request request, Object response);

  /**
   * Runs any additional processing logic on a request after it has failed.
   *
   * @param request the request that generated an error.
   * @param ex The error that resulted from executing the request.
   */
  void afterError(Request request, Exception ex);
}
