package org.qas.api;

import javax.xml.bind.DatatypeConverter;
import java.util.Map;

/**
 * @author haimnguyen
 * @version $Id Strings Jul 11, 2014 6:17 PM haimnguyen $
 * @since 1.0
 */
public final class StringUtil {
  private StringUtil() {
  }

  public static boolean isNullOrEmpty(String string) {
    return string == null || string.isEmpty();
  }

  public static String expandParams(String path, Map<String, Object> params) {
    if (params == null || params.size() <= 0) {
      return path;
    }
    StringBuilder builder = new StringBuilder();
    params.forEach((key, value) -> {
      builder.append("&" + key + "=" + value);
    });
    return path + "?" + builder.toString().substring(1);
  }

  /**
   * base64 encode string
   *
   * @param s string to encode
   * @return encoded string
   */
  public static String base64Encode(String s) {
    return DatatypeConverter.printBase64Binary((s).getBytes());
  }
}
