package org.qas.api;

/**
 * RequestClientOptions
 *
 * @author: Dzung Nguyen
 * @version: $Id RequestClientOptions 2014-03-26 15:11:30z dungvnguyen $
 * @since 1.0
 */
public class RequestClientOptions {
  //~ class properties ========================================================
  private String clientMarker;

  //~ class members ===========================================================
  RequestClientOptions () {}

  /**
   * @return all client markers as a space-delimited string.
   */
  public String getClientMarker() {
    return clientMarker;
  }

  /**
   * Adds the client marker, if it wasn't already present.
   *
   * @param clientMarker the client marker to add.
   */
  public void addClientMarker(String clientMarker) {
    if (this.clientMarker == null) this.clientMarker = "";
    this.clientMarker = createClientMarker(clientMarker);
  }

  private String createClientMarker(String clientMarker) {
    if (this.clientMarker.contains(clientMarker)) {
      return this.clientMarker;
    } else {
      return this.clientMarker + " " + clientMarker;
    }
  }
}
