package org.qas.api;

/**
 * ApiServiceResponse
 *
 * @author: Dzung Nguyen
 * @version: $Id ApiServiceResponse 2014-03-26 15:26:30z dungvnguyen $
 * @since 1.0
 */
public class ApiServiceResponse<T> {
  //~ class properties ========================================================
  /** the result contained by this response. */
  private T result;

  /** Additional metadata of this response. */
  private ResponseMetadata metadata;

  //~ class members ===========================================================
  /**
   * @return the result contained by this response.
   */
  public T getResult() {
    return result;
  }

  /**
   * Sets the result contained by this response.
   *
   * @param result The result contained by this response.
   */
  public void setResult(T result) {
    this.result = result;
  }

  /**
   * Sets the result contained by this response and return the updated
   * service response object.
   *
   * @param result the result contained by this response.
   * @return the updated service response object that contained the
   *         new result.
   */
  public ApiServiceResponse<T> withResult(T result) {
    setResult(result);
    return this;
  }

  /**
   * @return the response metadata for this response.
   */
  public ResponseMetadata getMetadata() {
    return metadata;
  }

  /**
   * Sets the response metadata for this response.
   *
   * @param metadata the specified metadata for this response.
   */
  public void setMetadata(ResponseMetadata metadata) {
    this.metadata = metadata;
  }

  /**
   * Sets the response metadata for this response and return the updated
   * response service object.
   *
   * @param metadata the specified metadata for this response.
   * @return the updated response service object with the new metadata.
   */
  public ApiServiceResponse<T> withMetadata(ResponseMetadata metadata) {
    setMetadata(metadata);
    return this;
  }
}
