package org.qas.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.util.HashMap;
import java.util.Map;

/**
 * ApiServiceRequest
 *
 * @author: Dzung Nguyen
 * @version: $Id ApiServiceRequest 2014-03-26 15:10:30z dungvnguyen $
 * @since 1.0
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public abstract class ApiServiceRequest {
  //~ class properties ========================================================
  /**
   * arbitrary options storage for {@link ApiServiceRequest}s.
   */
  @JsonIgnore
  private final RequestClientOptions requestClientOptions = new RequestClientOptions();

  /**
   * The optional credentials to use for this request.
   */
  @JsonIgnore
  private Credentials credentials;

  //~ class members ===========================================================

  /**
   * @return the optional credentials to use to sign this request, overriding
   * the default credentials set at the client level.
   */
  public Credentials getCredentials() {
    return credentials;
  }

  /**
   * Sets the optional credentials to use to sign this request, overriding the
   * default credentials set at a client level.
   *
   * @param credentials The optional credentials to use for this request.
   */
  public void setCredentials(Credentials credentials) {
    this.credentials = credentials;
  }

  /**
   * Sets the optional credentials to use to sign this request, overriding the
   * default credentials set at a client level and return the updated service
   * request object.
   *
   * @param credentials the optional credentials to use for this request.
   * @return the updated service request object with the new credentials.
   */
  public ApiServiceRequest withCredentials(Credentials credentials) {
    setCredentials(credentials);
    return this;
  }

  /**
   * @return the basic request parameter information.
   */
  public Map<String, String> copyPrivateRequestParameters() {
    return new HashMap<>();
  }

  /**
   * @return the options stored with this request object.
   */
  public RequestClientOptions getRequestClientOptions() {
    return requestClientOptions;
  }

  @Override
  public String toString() {
    return JsonMapper.toJson(this);
  }
}
