/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.put;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.pushtorefresh.storio.sqlite.operations.put.PutResult;
import java.util.Collections;
import java.util.Map;

public final class PutResults<T> {
    @NonNull
    private final Map<T, PutResult> results;
    @Nullable
    private volatile transient Integer numberOfInsertsCache;
    @Nullable
    private volatile transient Integer numberOfUpdatesCache;

    private PutResults(@NonNull Map<T, PutResult> putResults) {
        this.results = Collections.unmodifiableMap(putResults);
    }

    @NonNull
    public static <T> PutResults<T> newInstance(@NonNull Map<T, PutResult> putResults) {
        return new PutResults<T>(putResults);
    }

    @NonNull
    public Map<T, PutResult> results() {
        return this.results;
    }

    public int numberOfInserts() {
        Integer cachedValue = this.numberOfInsertsCache;
        if (cachedValue != null) {
            return cachedValue;
        }
        int numberOfInserts = 0;
        for (T object : this.results.keySet()) {
            if (!this.results.get(object).wasInserted()) continue;
            ++numberOfInserts;
        }
        this.numberOfInsertsCache = numberOfInserts;
        return numberOfInserts;
    }

    public int numberOfUpdates() {
        Integer cachedValue = this.numberOfUpdatesCache;
        if (cachedValue != null) {
            return cachedValue;
        }
        int numberOfUpdates = 0;
        for (T object : this.results.keySet()) {
            PutResult putResult = this.results.get(object);
            if (!putResult.wasUpdated()) continue;
            numberOfUpdates += putResult.numberOfRowsUpdated().intValue();
        }
        this.numberOfUpdatesCache = numberOfUpdates;
        return numberOfUpdates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutResults that = (PutResults)o;
        return this.results.equals(that.results);
    }

    public int hashCode() {
        return this.results.hashCode();
    }

    public String toString() {
        return "PutResults{results=" + this.results + '}';
    }
}

