/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.put;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.pushtorefresh.storio.StorIOException;
import com.pushtorefresh.storio.internal.Environment;
import com.pushtorefresh.storio.operations.PreparedOperation;
import com.pushtorefresh.storio.operations.internal.OnSubscribeExecuteAsBlocking;
import com.pushtorefresh.storio.sqlite.Changes;
import com.pushtorefresh.storio.sqlite.SQLiteTypeMapping;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import com.pushtorefresh.storio.sqlite.operations.put.PreparedPut;
import com.pushtorefresh.storio.sqlite.operations.put.PutResolver;
import com.pushtorefresh.storio.sqlite.operations.put.PutResult;
import rx.Observable;
import rx.schedulers.Schedulers;

public final class PreparedPutObject<T>
extends PreparedPut<PutResult> {
    @NonNull
    private final T object;
    @Nullable
    private final PutResolver<T> explicitPutResolver;

    PreparedPutObject(@NonNull StorIOSQLite storIOSQLite, @NonNull T object, @Nullable PutResolver<T> explicitPutResolver) {
        super(storIOSQLite);
        this.object = object;
        this.explicitPutResolver = explicitPutResolver;
    }

    @WorkerThread
    @NonNull
    public PutResult executeAsBlocking() {
        try {
            PutResolver<Object> putResolver;
            StorIOSQLite.Internal internal = this.storIOSQLite.internal();
            if (this.explicitPutResolver != null) {
                putResolver = this.explicitPutResolver;
            } else {
                SQLiteTypeMapping<?> typeMapping = internal.typeMapping(this.object.getClass());
                if (typeMapping == null) {
                    throw new IllegalStateException("Object does not have type mapping: object = " + this.object + ", object.class = " + this.object.getClass() + "," + "db was not affected by this operation, please add type mapping for this type");
                }
                putResolver = typeMapping.putResolver();
            }
            PutResult putResult = putResolver.performPut(this.storIOSQLite, this.object);
            internal.notifyAboutChanges(Changes.newInstance(putResult.affectedTables()));
            return putResult;
        }
        catch (Exception exception) {
            throw new StorIOException((Throwable)exception);
        }
    }

    @NonNull
    @CheckResult
    public Observable<PutResult> createObservable() {
        Environment.throwExceptionIfRxJavaIsNotAvailable((String)"createObservable()");
        return Observable.create((Observable.OnSubscribe)OnSubscribeExecuteAsBlocking.newInstance((PreparedOperation)this)).subscribeOn(Schedulers.io());
    }

    public static final class Builder<T> {
        @NonNull
        private final StorIOSQLite storIOSQLite;
        @NonNull
        private final T object;
        private PutResolver<T> putResolver;

        Builder(@NonNull StorIOSQLite storIOSQLite, @NonNull T object) {
            this.storIOSQLite = storIOSQLite;
            this.object = object;
        }

        @NonNull
        public Builder<T> withPutResolver(@NonNull PutResolver<T> putResolver) {
            this.putResolver = putResolver;
            return this;
        }

        @NonNull
        public PreparedPutObject<T> prepare() {
            return new PreparedPutObject<T>(this.storIOSQLite, this.object, this.putResolver);
        }
    }
}

