/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.put;

import android.content.ContentValues;
import android.database.Cursor;
import android.support.annotation.NonNull;
import com.pushtorefresh.storio.internal.InternalQueries;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import com.pushtorefresh.storio.sqlite.operations.put.PutResolver;
import com.pushtorefresh.storio.sqlite.operations.put.PutResult;
import com.pushtorefresh.storio.sqlite.queries.InsertQuery;
import com.pushtorefresh.storio.sqlite.queries.Query;
import com.pushtorefresh.storio.sqlite.queries.UpdateQuery;

public abstract class DefaultPutResolver<T>
extends PutResolver<T> {
    @NonNull
    protected abstract InsertQuery mapToInsertQuery(@NonNull T var1);

    @NonNull
    protected abstract UpdateQuery mapToUpdateQuery(@NonNull T var1);

    @NonNull
    protected abstract ContentValues mapToContentValues(@NonNull T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public PutResult performPut(@NonNull StorIOSQLite storIOSQLite, @NonNull T object) {
        UpdateQuery updateQuery = this.mapToUpdateQuery(object);
        storIOSQLite.internal().beginTransaction();
        try {
            PutResult putResult;
            Cursor cursor = storIOSQLite.internal().query(Query.builder().table(updateQuery.table()).where(InternalQueries.nullableString((String)updateQuery.where())).whereArgs(InternalQueries.nullableArrayOfStrings(updateQuery.whereArgs())).build());
            try {
                ContentValues contentValues = this.mapToContentValues(object);
                if (cursor.getCount() == 0) {
                    InsertQuery insertQuery = this.mapToInsertQuery(object);
                    long insertedId = storIOSQLite.internal().insert(insertQuery, contentValues);
                    putResult = PutResult.newInsertResult(insertedId, insertQuery.table());
                } else {
                    int numberOfRowsUpdated = storIOSQLite.internal().update(updateQuery, contentValues);
                    putResult = PutResult.newUpdateResult(numberOfRowsUpdated, updateQuery.table());
                }
            }
            finally {
                cursor.close();
            }
            storIOSQLite.internal().setTransactionSuccessful();
            PutResult putResult2 = putResult;
            return putResult2;
        }
        finally {
            storIOSQLite.internal().endTransaction();
        }
    }
}

