/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.execute;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.pushtorefresh.storio.StorIOException;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.Environment;
import com.pushtorefresh.storio.operations.PreparedOperation;
import com.pushtorefresh.storio.operations.internal.OnSubscribeExecuteAsBlocking;
import com.pushtorefresh.storio.sqlite.Changes;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import com.pushtorefresh.storio.sqlite.queries.RawQuery;
import java.util.Set;
import rx.Observable;
import rx.schedulers.Schedulers;

public final class PreparedExecuteSQL
implements PreparedOperation<Object> {
    @NonNull
    private final StorIOSQLite storIOSQLite;
    @NonNull
    private final RawQuery rawQuery;

    PreparedExecuteSQL(@NonNull StorIOSQLite storIOSQLite, @NonNull RawQuery rawQuery) {
        this.storIOSQLite = storIOSQLite;
        this.rawQuery = rawQuery;
    }

    @WorkerThread
    @NonNull
    public Object executeAsBlocking() {
        try {
            this.storIOSQLite.internal().executeSQL(this.rawQuery);
            Set<String> affectedTables = this.rawQuery.affectsTables();
            if (affectedTables.size() > 0) {
                this.storIOSQLite.internal().notifyAboutChanges(Changes.newInstance(affectedTables));
            }
            return new Object();
        }
        catch (Exception exception) {
            throw new StorIOException((Throwable)exception);
        }
    }

    @NonNull
    @CheckResult
    public Observable<Object> createObservable() {
        Environment.throwExceptionIfRxJavaIsNotAvailable((String)"createObservable()");
        return Observable.create((Observable.OnSubscribe)OnSubscribeExecuteAsBlocking.newInstance((PreparedOperation)this)).subscribeOn(Schedulers.io());
    }

    public static final class CompleteBuilder {
        @NonNull
        private final StorIOSQLite storIOSQLite;
        @NonNull
        private final RawQuery rawQuery;

        CompleteBuilder(@NonNull StorIOSQLite storIOSQLite, @NonNull RawQuery rawQuery) {
            this.storIOSQLite = storIOSQLite;
            this.rawQuery = rawQuery;
        }

        @NonNull
        public PreparedExecuteSQL prepare() {
            return new PreparedExecuteSQL(this.storIOSQLite, this.rawQuery);
        }
    }

    public static final class Builder {
        @NonNull
        private final StorIOSQLite storIOSQLite;

        public Builder(@NonNull StorIOSQLite storIOSQLite) {
            this.storIOSQLite = storIOSQLite;
        }

        @NonNull
        public CompleteBuilder withQuery(@NonNull RawQuery rawQuery) {
            Checks.checkNotNull((Object)rawQuery, (String)"Please set query object");
            return new CompleteBuilder(this.storIOSQLite, rawQuery);
        }
    }
}

