/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.queries;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.pushtorefresh.storio.internal.Checks;

public final class InsertQuery {
    @NonNull
    private final String table;
    @Nullable
    private final String nullColumnHack;

    private InsertQuery(@NonNull String table, @Nullable String nullColumnHack) {
        this.table = table;
        this.nullColumnHack = nullColumnHack;
    }

    @NonNull
    public String table() {
        return this.table;
    }

    @Nullable
    public String nullColumnHack() {
        return this.nullColumnHack;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertQuery that = (InsertQuery)o;
        if (this.nullColumnHack != null ? !this.nullColumnHack.equals(that.nullColumnHack) : that.nullColumnHack != null) {
            return false;
        }
        return this.table.equals(that.table);
    }

    public int hashCode() {
        int result = this.table.hashCode();
        result = 31 * result + (this.nullColumnHack != null ? this.nullColumnHack.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "InsertQuery{table='" + this.table + '\'' + ", nullColumnHack='" + this.nullColumnHack + '\'' + '}';
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class CompleteBuilder {
        @NonNull
        private final String table;
        private String nullColumnHack;

        CompleteBuilder(@NonNull String table) {
            this.table = table;
        }

        @NonNull
        public CompleteBuilder nullColumnHack(@Nullable String nullColumnHack) {
            this.nullColumnHack = nullColumnHack;
            return this;
        }

        @NonNull
        public InsertQuery build() {
            return new InsertQuery(this.table, this.nullColumnHack);
        }
    }

    public static final class Builder {
        Builder() {
        }

        @NonNull
        public CompleteBuilder table(@NonNull String table) {
            Checks.checkNotEmpty((String)table, (String)"Table name is null or empty");
            return new CompleteBuilder(table);
        }
    }
}

