/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.put;

import android.content.ContentValues;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.pushtorefresh.storio.StorIOException;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.Environment;
import com.pushtorefresh.storio.operations.PreparedOperation;
import com.pushtorefresh.storio.operations.internal.OnSubscribeExecuteAsBlocking;
import com.pushtorefresh.storio.sqlite.Changes;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import com.pushtorefresh.storio.sqlite.operations.put.PreparedPut;
import com.pushtorefresh.storio.sqlite.operations.put.PutResolver;
import com.pushtorefresh.storio.sqlite.operations.put.PutResult;
import com.pushtorefresh.storio.sqlite.operations.put.PutResults;
import java.util.HashMap;
import java.util.HashSet;
import rx.Observable;
import rx.schedulers.Schedulers;

public final class PreparedPutContentValuesIterable
extends PreparedPut<PutResults<ContentValues>> {
    @NonNull
    private final Iterable<ContentValues> contentValuesIterable;
    @NonNull
    private final PutResolver<ContentValues> putResolver;
    private final boolean useTransaction;

    PreparedPutContentValuesIterable(@NonNull StorIOSQLite storIOSQLite, @NonNull Iterable<ContentValues> contentValuesIterable, @NonNull PutResolver<ContentValues> putResolver, boolean useTransaction) {
        super(storIOSQLite);
        this.contentValuesIterable = contentValuesIterable;
        this.putResolver = putResolver;
        this.useTransaction = useTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NonNull
    public PutResults<ContentValues> executeAsBlocking() {
        try {
            StorIOSQLite.Internal internal = this.storIOSQLite.internal();
            HashMap<ContentValues, PutResult> putResults = new HashMap<ContentValues, PutResult>();
            if (this.useTransaction) {
                internal.beginTransaction();
            }
            boolean transactionSuccessful = false;
            try {
                for (ContentValues contentValues : this.contentValuesIterable) {
                    PutResult putResult = this.putResolver.performPut(this.storIOSQLite, contentValues);
                    putResults.put(contentValues, putResult);
                    if (this.useTransaction) continue;
                    internal.notifyAboutChanges(Changes.newInstance(putResult.affectedTables()));
                }
                if (this.useTransaction) {
                    internal.setTransactionSuccessful();
                    transactionSuccessful = true;
                }
            }
            finally {
                if (this.useTransaction) {
                    internal.endTransaction();
                    if (transactionSuccessful) {
                        HashSet<String> affectedTables = new HashSet<String>(1);
                        for (ContentValues contentValues : putResults.keySet()) {
                            affectedTables.addAll(((PutResult)putResults.get(contentValues)).affectedTables());
                        }
                        internal.notifyAboutChanges(Changes.newInstance(affectedTables));
                    }
                }
            }
            return PutResults.newInstance(putResults);
        }
        catch (Exception exception) {
            throw new StorIOException((Throwable)exception);
        }
    }

    @NonNull
    public Observable<PutResults<ContentValues>> createObservable() {
        Environment.throwExceptionIfRxJavaIsNotAvailable((String)"createObservable()");
        return Observable.create((Observable.OnSubscribe)OnSubscribeExecuteAsBlocking.newInstance((PreparedOperation)this)).subscribeOn(Schedulers.io());
    }

    public static final class CompleteBuilder {
        @NonNull
        private final StorIOSQLite storIOSQLite;
        @NonNull
        private final Iterable<ContentValues> contentValuesIterable;
        @NonNull
        private final PutResolver<ContentValues> putResolver;
        private boolean useTransaction = true;

        CompleteBuilder(@NonNull StorIOSQLite storIOSQLite, @NonNull Iterable<ContentValues> contentValuesIterable, @NonNull PutResolver<ContentValues> putResolver) {
            this.storIOSQLite = storIOSQLite;
            this.contentValuesIterable = contentValuesIterable;
            this.putResolver = putResolver;
        }

        @NonNull
        public CompleteBuilder useTransaction(boolean useTransaction) {
            this.useTransaction = useTransaction;
            return this;
        }

        @NonNull
        public PreparedPutContentValuesIterable prepare() {
            return new PreparedPutContentValuesIterable(this.storIOSQLite, this.contentValuesIterable, this.putResolver, this.useTransaction);
        }
    }

    public static final class Builder {
        @NonNull
        private final StorIOSQLite storIOSQLite;
        @NonNull
        private final Iterable<ContentValues> contentValuesIterable;

        Builder(@NonNull StorIOSQLite storIOSQLite, @NonNull Iterable<ContentValues> contentValuesIterable) {
            this.storIOSQLite = storIOSQLite;
            this.contentValuesIterable = contentValuesIterable;
        }

        @NonNull
        public CompleteBuilder withPutResolver(@NonNull PutResolver<ContentValues> putResolver) {
            Checks.checkNotNull(putResolver, (String)"Please specify put resolver");
            return new CompleteBuilder(this.storIOSQLite, this.contentValuesIterable, putResolver);
        }
    }
}

