/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.queries;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.InternalQueries;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class Query {
    private final boolean distinct;
    @NonNull
    private final String table;
    @NonNull
    private final List<String> columns;
    @NonNull
    private final String where;
    @NonNull
    private final List<String> whereArgs;
    @NonNull
    private final String groupBy;
    @NonNull
    private final String having;
    @NonNull
    private final String orderBy;
    @NonNull
    private final String limit;
    @NonNull
    private final Set<String> observesTags;

    private Query(boolean distinct, @NonNull String table, @Nullable List<String> columns, @Nullable String where, @Nullable List<String> whereArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit, @Nullable Set<String> observesTags) {
        if (observesTags != null) {
            for (String tag : observesTags) {
                Checks.checkNotEmpty((String)tag, (String)("observesTag must not be null or empty, observesTags = " + observesTags));
            }
        }
        this.distinct = distinct;
        this.table = table;
        this.columns = InternalQueries.unmodifiableNonNullListOfStrings(columns);
        this.where = InternalQueries.nonNullString((String)where);
        this.whereArgs = InternalQueries.unmodifiableNonNullListOfStrings(whereArgs);
        this.groupBy = InternalQueries.nonNullString((String)groupBy);
        this.having = InternalQueries.nonNullString((String)having);
        this.orderBy = InternalQueries.nonNullString((String)orderBy);
        this.limit = InternalQueries.nonNullString((String)limit);
        this.observesTags = InternalQueries.unmodifiableNonNullSet(observesTags);
    }

    public boolean distinct() {
        return this.distinct;
    }

    @NonNull
    public String table() {
        return this.table;
    }

    @NonNull
    public List<String> columns() {
        return this.columns;
    }

    @NonNull
    public String where() {
        return this.where;
    }

    @NonNull
    public List<String> whereArgs() {
        return this.whereArgs;
    }

    @NonNull
    public String groupBy() {
        return this.groupBy;
    }

    @NonNull
    public String having() {
        return this.having;
    }

    @NonNull
    public String orderBy() {
        return this.orderBy;
    }

    @NonNull
    public String limit() {
        return this.limit;
    }

    @NonNull
    public Set<String> observesTags() {
        return this.observesTags;
    }

    @NonNull
    public CompleteBuilder toBuilder() {
        return new CompleteBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        if (this.distinct != query.distinct) {
            return false;
        }
        if (!this.table.equals(query.table)) {
            return false;
        }
        if (!this.columns.equals(query.columns)) {
            return false;
        }
        if (!this.where.equals(query.where)) {
            return false;
        }
        if (!this.whereArgs.equals(query.whereArgs)) {
            return false;
        }
        if (!this.groupBy.equals(query.groupBy)) {
            return false;
        }
        if (!this.having.equals(query.having)) {
            return false;
        }
        if (!this.orderBy.equals(query.orderBy)) {
            return false;
        }
        if (!this.limit.equals(query.limit)) {
            return false;
        }
        return this.observesTags.equals(query.observesTags);
    }

    public int hashCode() {
        int result = this.distinct ? 1 : 0;
        result = 31 * result + this.table.hashCode();
        result = 31 * result + this.columns.hashCode();
        result = 31 * result + this.where.hashCode();
        result = 31 * result + this.whereArgs.hashCode();
        result = 31 * result + this.groupBy.hashCode();
        result = 31 * result + this.having.hashCode();
        result = 31 * result + this.orderBy.hashCode();
        result = 31 * result + this.limit.hashCode();
        result = 31 * result + this.observesTags.hashCode();
        return result;
    }

    public String toString() {
        return "Query{distinct=" + this.distinct + ", table='" + this.table + '\'' + ", columns=" + this.columns + ", where='" + this.where + '\'' + ", whereArgs=" + this.whereArgs + ", groupBy='" + this.groupBy + '\'' + ", having='" + this.having + '\'' + ", orderBy='" + this.orderBy + '\'' + ", limit='" + this.limit + '\'' + ", observesTags='" + this.observesTags + '\'' + '}';
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class CompleteBuilder {
        @NonNull
        private String table;
        private boolean distinct;
        private List<String> columns;
        private String where;
        private List<String> whereArgs;
        private String groupBy;
        private String having;
        private String orderBy;
        private String limit;
        @Nullable
        private Set<String> observesTags;

        CompleteBuilder(@NonNull String table) {
            this.table = table;
        }

        CompleteBuilder(@NonNull Query query) {
            this.table = query.table;
            this.distinct = query.distinct;
            this.columns = query.columns;
            this.where = query.where;
            this.whereArgs = query.whereArgs;
            this.groupBy = query.groupBy;
            this.having = query.having;
            this.orderBy = query.orderBy;
            this.limit = query.limit;
            this.observesTags = query.observesTags;
        }

        @NonNull
        public CompleteBuilder table(@NonNull String table) {
            Checks.checkNotEmpty((String)table, (String)"Table name is null or empty");
            this.table = table;
            return this;
        }

        @NonNull
        public CompleteBuilder distinct(boolean distinct) {
            this.distinct = distinct;
            return this;
        }

        @NonNull
        public CompleteBuilder columns(String ... columns) {
            this.columns = InternalQueries.unmodifiableNonNullListOfStrings((Object[])columns);
            return this;
        }

        @NonNull
        public CompleteBuilder where(@Nullable String where) {
            this.where = where;
            return this;
        }

        @NonNull
        public <T> CompleteBuilder whereArgs(T ... whereArgs) {
            this.whereArgs = InternalQueries.unmodifiableNonNullListOfStrings((Object[])whereArgs);
            return this;
        }

        @NonNull
        public CompleteBuilder whereArgs(@Nullable List<?> whereArgs) {
            this.whereArgs = InternalQueries.unmodifiableNonNullListOfStrings(whereArgs);
            return this;
        }

        @NonNull
        public CompleteBuilder groupBy(@Nullable String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        @NonNull
        public CompleteBuilder having(@Nullable String having) {
            this.having = having;
            return this;
        }

        @NonNull
        public CompleteBuilder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @NonNull
        public CompleteBuilder limit(@Nullable String limit) {
            this.limit = limit;
            return this;
        }

        @NonNull
        public CompleteBuilder limit(int limit) {
            if (limit <= 0) {
                throw new IllegalStateException("Parameter `limit` should be positive, but was = " + limit);
            }
            this.limit = String.valueOf(limit);
            return this;
        }

        @NonNull
        public CompleteBuilder limit(int offset, int quantity) {
            if (offset < 0) {
                throw new IllegalStateException("Parameter `offset` should not be negative, but was = " + offset);
            }
            if (quantity <= 0) {
                throw new IllegalStateException("Parameter `quantity` should be positive, but was = " + quantity);
            }
            this.limit = String.valueOf(offset) + ", " + String.valueOf(quantity);
            return this;
        }

        @NonNull
        public CompleteBuilder observesTags(@NonNull String tag, String ... tags) {
            this.observesTags = InternalQueries.nonNullSet((String)tag, (String[])tags);
            return this;
        }

        @NonNull
        public CompleteBuilder observesTags(@Nullable Collection<String> tags) {
            this.observesTags = InternalQueries.nonNullSet(tags);
            return this;
        }

        @NonNull
        public Query build() {
            if (this.where == null && this.whereArgs != null && !this.whereArgs.isEmpty()) {
                throw new IllegalStateException("You can not use whereArgs without where clause");
            }
            return new Query(this.distinct, this.table, this.columns, this.where, this.whereArgs, this.groupBy, this.having, this.orderBy, this.limit, this.observesTags);
        }
    }

    public static final class Builder {
        Builder() {
        }

        @NonNull
        public CompleteBuilder table(@NonNull String table) {
            Checks.checkNotEmpty((String)table, (String)"Table name is null or empty");
            return new CompleteBuilder(table);
        }
    }
}

