/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.queries;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.InternalQueries;
import java.util.Collection;
import java.util.Set;

public final class InsertQuery {
    @NonNull
    private final String table;
    @Nullable
    private final String nullColumnHack;
    @NonNull
    private final Set<String> affectsTags;

    private InsertQuery(@NonNull String table, @Nullable String nullColumnHack, @Nullable Set<String> affectsTags) {
        if (affectsTags != null) {
            for (String tag : affectsTags) {
                Checks.checkNotEmpty((String)tag, (String)("affectsTag must not be null or empty, affectsTags = " + affectsTags));
            }
        }
        this.table = table;
        this.nullColumnHack = nullColumnHack;
        this.affectsTags = InternalQueries.unmodifiableNonNullSet(affectsTags);
    }

    @NonNull
    public String table() {
        return this.table;
    }

    @Nullable
    public String nullColumnHack() {
        return this.nullColumnHack;
    }

    @NonNull
    public Set<String> affectsTags() {
        return this.affectsTags;
    }

    @NonNull
    public CompleteBuilder toBuilder() {
        return new CompleteBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertQuery that = (InsertQuery)o;
        if (!this.table.equals(that.table)) {
            return false;
        }
        if (this.nullColumnHack != null ? !this.nullColumnHack.equals(that.nullColumnHack) : that.nullColumnHack != null) {
            return false;
        }
        return this.affectsTags.equals(that.affectsTags);
    }

    public int hashCode() {
        int result = this.table.hashCode();
        result = 31 * result + (this.nullColumnHack != null ? this.nullColumnHack.hashCode() : 0);
        result = 31 * result + this.affectsTags.hashCode();
        return result;
    }

    public String toString() {
        return "InsertQuery{table='" + this.table + '\'' + ", nullColumnHack='" + this.nullColumnHack + '\'' + ", affectsTags='" + this.affectsTags + '\'' + '}';
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class CompleteBuilder {
        @NonNull
        private String table;
        private String nullColumnHack;
        @Nullable
        private Set<String> affectsTags;

        CompleteBuilder(@NonNull String table) {
            this.table = table;
        }

        CompleteBuilder(@NonNull InsertQuery insertQuery) {
            this.table = insertQuery.table;
            this.nullColumnHack = insertQuery.nullColumnHack;
            this.affectsTags = insertQuery.affectsTags;
        }

        @NonNull
        public CompleteBuilder table(@NonNull String table) {
            Checks.checkNotEmpty((String)table, (String)"Table name is null or empty");
            this.table = table;
            return this;
        }

        @NonNull
        public CompleteBuilder nullColumnHack(@Nullable String nullColumnHack) {
            this.nullColumnHack = nullColumnHack;
            return this;
        }

        @NonNull
        public CompleteBuilder affectsTags(@NonNull String tag, String ... tags) {
            this.affectsTags = InternalQueries.nonNullSet((String)tag, (String[])tags);
            return this;
        }

        @NonNull
        public CompleteBuilder affectsTags(@Nullable Collection<String> tags) {
            this.affectsTags = InternalQueries.nonNullSet(tags);
            return this;
        }

        @NonNull
        public InsertQuery build() {
            return new InsertQuery(this.table, this.nullColumnHack, this.affectsTags);
        }
    }

    public static final class Builder {
        Builder() {
        }

        @NonNull
        public CompleteBuilder table(@NonNull String table) {
            Checks.checkNotEmpty((String)table, (String)"Table name is null or empty");
            return new CompleteBuilder(table);
        }
    }
}

