/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.put;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.pushtorefresh.storio.StorIOException;
import com.pushtorefresh.storio.sqlite.Changes;
import com.pushtorefresh.storio.sqlite.SQLiteTypeMapping;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import com.pushtorefresh.storio.sqlite.operations.internal.RxJavaUtils;
import com.pushtorefresh.storio.sqlite.operations.put.PreparedPut;
import com.pushtorefresh.storio.sqlite.operations.put.PutResolver;
import com.pushtorefresh.storio.sqlite.operations.put.PutResult;
import rx.Completable;
import rx.Observable;
import rx.Single;

public class PreparedPutObject<T>
extends PreparedPut<PutResult> {
    @NonNull
    private final T object;
    @Nullable
    private final PutResolver<T> explicitPutResolver;

    PreparedPutObject(@NonNull StorIOSQLite storIOSQLite, @NonNull T object, @Nullable PutResolver<T> explicitPutResolver) {
        super(storIOSQLite);
        this.object = object;
        this.explicitPutResolver = explicitPutResolver;
    }

    @WorkerThread
    @NonNull
    public PutResult executeAsBlocking() {
        try {
            PutResolver<Object> putResolver;
            StorIOSQLite.LowLevel lowLevel = this.storIOSQLite.lowLevel();
            if (this.explicitPutResolver != null) {
                putResolver = this.explicitPutResolver;
            } else {
                SQLiteTypeMapping<?> typeMapping = lowLevel.typeMapping(this.object.getClass());
                if (typeMapping == null) {
                    throw new IllegalStateException("Object does not have type mapping: object = " + this.object + ", object.class = " + this.object.getClass() + ", db was not affected by this operation, please add type mapping for this type");
                }
                putResolver = typeMapping.putResolver();
            }
            PutResult putResult = putResolver.performPut(this.storIOSQLite, this.object);
            if (putResult.wasInserted() || putResult.wasUpdated()) {
                Changes changes = Changes.newInstance(putResult.affectedTables(), putResult.affectedTags());
                lowLevel.notifyAboutChanges(changes);
            }
            return putResult;
        }
        catch (Exception exception) {
            throw new StorIOException("Error has occurred during Put operation. object = " + this.object, (Throwable)exception);
        }
    }

    @NonNull
    @CheckResult
    public Observable<PutResult> createObservable() {
        return this.asRxObservable();
    }

    @NonNull
    @CheckResult
    public Observable<PutResult> asRxObservable() {
        return RxJavaUtils.createObservable(this.storIOSQLite, this);
    }

    @NonNull
    @CheckResult
    public Single<PutResult> asRxSingle() {
        return RxJavaUtils.createSingle(this.storIOSQLite, this);
    }

    @NonNull
    @CheckResult
    public Completable asRxCompletable() {
        return RxJavaUtils.createCompletable(this.storIOSQLite, this);
    }

    public static class Builder<T> {
        @NonNull
        private final StorIOSQLite storIOSQLite;
        @NonNull
        private final T object;
        private PutResolver<T> putResolver;

        Builder(@NonNull StorIOSQLite storIOSQLite, @NonNull T object) {
            this.storIOSQLite = storIOSQLite;
            this.object = object;
        }

        @NonNull
        public Builder<T> withPutResolver(@NonNull PutResolver<T> putResolver) {
            this.putResolver = putResolver;
            return this;
        }

        @NonNull
        public PreparedPutObject<T> prepare() {
            return new PreparedPutObject<T>(this.storIOSQLite, this.object, this.putResolver);
        }
    }
}

