/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.operations.get;

import android.database.Cursor;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.pushtorefresh.storio.StorIOException;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.Environment;
import com.pushtorefresh.storio.operations.PreparedOperation;
import com.pushtorefresh.storio.operations.internal.MapSomethingToExecuteAsBlocking;
import com.pushtorefresh.storio.operations.internal.OnSubscribeExecuteAsBlocking;
import com.pushtorefresh.storio.sqlite.SQLiteTypeMapping;
import com.pushtorefresh.storio.sqlite.StorIOSQLite;
import com.pushtorefresh.storio.sqlite.impl.ChangesFilter;
import com.pushtorefresh.storio.sqlite.operations.get.GetResolver;
import com.pushtorefresh.storio.sqlite.operations.get.PreparedGet;
import com.pushtorefresh.storio.sqlite.operations.internal.RxJavaUtils;
import com.pushtorefresh.storio.sqlite.queries.Query;
import com.pushtorefresh.storio.sqlite.queries.RawQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import rx.Observable;
import rx.Single;

public class PreparedGetListOfObjects<T>
extends PreparedGet<List<T>> {
    @NonNull
    private final Class<T> type;
    @Nullable
    private final GetResolver<T> explicitGetResolver;

    PreparedGetListOfObjects(@NonNull StorIOSQLite storIOSQLite, @NonNull Class<T> type, @NonNull Query query, @Nullable GetResolver<T> explicitGetResolver) {
        super(storIOSQLite, query);
        this.type = type;
        this.explicitGetResolver = explicitGetResolver;
    }

    PreparedGetListOfObjects(@NonNull StorIOSQLite storIOSQLite, @NonNull Class<T> type, @NonNull RawQuery rawQuery, @Nullable GetResolver<T> explicitGetResolver) {
        super(storIOSQLite, rawQuery);
        this.type = type;
        this.explicitGetResolver = explicitGetResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    @NonNull
    public List<T> executeAsBlocking() {
        try {
            Cursor cursor;
            GetResolver<T> getResolver;
            if (this.explicitGetResolver != null) {
                getResolver = this.explicitGetResolver;
            } else {
                SQLiteTypeMapping<T> typeMapping = this.storIOSQLite.lowLevel().typeMapping(this.type);
                if (typeMapping == null) {
                    throw new IllegalStateException("This type does not have type mapping: type = " + this.type + ",db was not touched by this operation, please add type mapping for this type");
                }
                getResolver = typeMapping.getResolver();
            }
            if (this.query != null) {
                cursor = getResolver.performGet(this.storIOSQLite, this.query);
            } else {
                if (this.rawQuery == null) throw new IllegalStateException("Please specify query");
                cursor = getResolver.performGet(this.storIOSQLite, this.rawQuery);
            }
            try {
                int count = cursor.getCount();
                if (count == 0) {
                    List list = Collections.EMPTY_LIST;
                    return list;
                }
                ArrayList<T> list = new ArrayList<T>(count);
                while (cursor.moveToNext()) {
                    list.add(getResolver.mapFromCursor(cursor));
                }
                List list2 = Collections.unmodifiableList(list);
                return list2;
            }
            finally {
                cursor.close();
            }
        }
        catch (Exception exception) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder().append("Error has occurred during Get operation. query = ");
            if (this.query != null) {
                object = this.query;
                throw new StorIOException(stringBuilder.append(object).toString(), (Throwable)exception);
            }
            object = this.rawQuery;
            throw new StorIOException(stringBuilder.append(object).toString(), (Throwable)exception);
        }
    }

    @NonNull
    @CheckResult
    public Observable<List<T>> createObservable() {
        return this.asRxObservable();
    }

    @NonNull
    @CheckResult
    public Observable<List<T>> asRxObservable() {
        Set<String> tags;
        Set<String> tables;
        Environment.throwExceptionIfRxJavaIsNotAvailable((String)"asRxObservable()");
        if (this.query != null) {
            tables = Collections.singleton(this.query.table());
            tags = this.query.observesTags();
        } else if (this.rawQuery != null) {
            tables = this.rawQuery.observesTables();
            tags = this.rawQuery.observesTags();
        } else {
            throw new IllegalStateException("Please specify query");
        }
        Observable observable = !tables.isEmpty() || !tags.isEmpty() ? ChangesFilter.applyForTablesAndTags(this.storIOSQLite.observeChanges(), tables, tags).map(MapSomethingToExecuteAsBlocking.newInstance((PreparedOperation)this)).startWith(Observable.create((Observable.OnSubscribe)OnSubscribeExecuteAsBlocking.newInstance((PreparedOperation)this))).onBackpressureLatest() : Observable.create((Observable.OnSubscribe)OnSubscribeExecuteAsBlocking.newInstance((PreparedOperation)this));
        return RxJavaUtils.subscribeOn(this.storIOSQLite, observable);
    }

    @NonNull
    @CheckResult
    public Single<List<T>> asRxSingle() {
        return RxJavaUtils.createSingle(this.storIOSQLite, this);
    }

    public static class CompleteBuilder<T> {
        @NonNull
        private final StorIOSQLite storIOSQLite;
        @NonNull
        private final Class<T> type;
        @Nullable
        Query query;
        @Nullable
        RawQuery rawQuery;
        @Nullable
        private GetResolver<T> getResolver;

        CompleteBuilder(@NonNull StorIOSQLite storIOSQLite, @NonNull Class<T> type, @NonNull Query query) {
            this.storIOSQLite = storIOSQLite;
            this.type = type;
            this.query = query;
            this.rawQuery = null;
        }

        CompleteBuilder(@NonNull StorIOSQLite storIOSQLite, @NonNull Class<T> type, @NonNull RawQuery rawQuery) {
            this.storIOSQLite = storIOSQLite;
            this.type = type;
            this.rawQuery = rawQuery;
            this.query = null;
        }

        @NonNull
        public CompleteBuilder<T> withGetResolver(@Nullable GetResolver<T> getResolver) {
            this.getResolver = getResolver;
            return this;
        }

        @NonNull
        public PreparedGetListOfObjects<T> prepare() {
            if (this.query != null) {
                return new PreparedGetListOfObjects<T>(this.storIOSQLite, this.type, this.query, this.getResolver);
            }
            if (this.rawQuery != null) {
                return new PreparedGetListOfObjects<T>(this.storIOSQLite, this.type, this.rawQuery, this.getResolver);
            }
            throw new IllegalStateException("Please specify Query or RawQuery");
        }
    }

    public static class Builder<T> {
        @NonNull
        private final StorIOSQLite storIOSQLite;
        @NonNull
        private final Class<T> type;

        Builder(@NonNull StorIOSQLite storIOSQLite, @NonNull Class<T> type) {
            this.storIOSQLite = storIOSQLite;
            this.type = type;
        }

        @NonNull
        public CompleteBuilder<T> withQuery(@NonNull Query query) {
            Checks.checkNotNull((Object)query, (String)"Please specify query");
            return new CompleteBuilder<T>(this.storIOSQLite, this.type, query);
        }

        @NonNull
        public CompleteBuilder<T> withQuery(@NonNull RawQuery rawQuery) {
            Checks.checkNotNull((Object)rawQuery, (String)"Please specify rawQuery");
            return new CompleteBuilder<T>(this.storIOSQLite, this.type, rawQuery);
        }
    }
}

