/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.queries;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.InternalQueries;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class UpdateQuery {
    @NonNull
    private final String table;
    @NonNull
    private final String where;
    @NonNull
    private final List<String> whereArgs;
    @NonNull
    private final Set<String> affectsTags;

    private UpdateQuery(@NonNull String table, @Nullable String where, @Nullable List<String> whereArgs, @Nullable Set<String> affectsTags) {
        if (affectsTags != null) {
            for (String tag : affectsTags) {
                Checks.checkNotEmpty((String)tag, (String)("affectsTag must not be null or empty, affectsTags = " + affectsTags));
            }
        }
        this.table = table;
        this.where = InternalQueries.nonNullString((String)where);
        this.whereArgs = InternalQueries.unmodifiableNonNullListOfStrings(whereArgs);
        this.affectsTags = InternalQueries.unmodifiableNonNullSet(affectsTags);
    }

    @NonNull
    public String table() {
        return this.table;
    }

    @NonNull
    public String where() {
        return this.where;
    }

    @NonNull
    public List<String> whereArgs() {
        return this.whereArgs;
    }

    @NonNull
    public Set<String> affectsTags() {
        return this.affectsTags;
    }

    @NonNull
    public CompleteBuilder toBuilder() {
        return new CompleteBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateQuery that = (UpdateQuery)o;
        if (!this.table.equals(that.table)) {
            return false;
        }
        if (!this.where.equals(that.where)) {
            return false;
        }
        if (!this.whereArgs.equals(that.whereArgs)) {
            return false;
        }
        return this.affectsTags.equals(that.affectsTags);
    }

    public int hashCode() {
        int result = this.table.hashCode();
        result = 31 * result + this.where.hashCode();
        result = 31 * result + this.whereArgs.hashCode();
        result = 31 * result + this.affectsTags.hashCode();
        return result;
    }

    public String toString() {
        return "UpdateQuery{table='" + this.table + '\'' + ", where='" + this.where + '\'' + ", whereArgs=" + this.whereArgs + ", affectsTags='" + this.affectsTags + '\'' + '}';
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class CompleteBuilder {
        @NonNull
        private String table;
        private String where;
        private List<String> whereArgs;
        @Nullable
        private Set<String> affectsTags;

        CompleteBuilder(@NonNull String table) {
            this.table = table;
        }

        CompleteBuilder(@NonNull UpdateQuery updateQuery) {
            this.table = updateQuery.table;
            this.where = updateQuery.where;
            this.whereArgs = updateQuery.whereArgs;
            this.affectsTags = updateQuery.affectsTags;
        }

        @NonNull
        public CompleteBuilder table(@NonNull String table) {
            Checks.checkNotEmpty((String)table, (String)"Table name is null or empty");
            this.table = table;
            return this;
        }

        @NonNull
        public CompleteBuilder where(@Nullable String where) {
            this.where = where;
            return this;
        }

        @NonNull
        public <T> CompleteBuilder whereArgs(T ... whereArgs) {
            this.whereArgs = InternalQueries.unmodifiableNonNullListOfStrings((Object[])whereArgs);
            return this;
        }

        @NonNull
        public CompleteBuilder affectsTags(@NonNull String tag, String ... tags) {
            this.affectsTags = InternalQueries.nonNullSet((String)tag, (String[])tags);
            return this;
        }

        @NonNull
        public CompleteBuilder affectsTags(@Nullable Collection<String> tags) {
            this.affectsTags = InternalQueries.nonNullSet(tags);
            return this;
        }

        @NonNull
        public UpdateQuery build() {
            if (this.where == null && this.whereArgs != null && !this.whereArgs.isEmpty()) {
                throw new IllegalStateException("You can not use whereArgs without where clause");
            }
            return new UpdateQuery(this.table, this.where, this.whereArgs, this.affectsTags);
        }
    }

    public static final class Builder {
        Builder() {
        }

        @NonNull
        public CompleteBuilder table(@NonNull String table) {
            Checks.checkNotEmpty((String)table, (String)"Table name is null or empty");
            return new CompleteBuilder(table);
        }
    }
}

