/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.InternalQueries;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public final class Changes {
    @NonNull
    private final Set<String> affectedTables;
    @NonNull
    private final Set<String> affectedTags;

    private Changes(@NonNull Set<String> affectedTables, @NonNull Set<String> affectedTags) {
        Checks.checkNotNull(affectedTables, (String)"Please specify affected tables");
        Checks.checkNotNull(affectedTags, (String)"Please specify affected tags");
        for (String tag : affectedTags) {
            Checks.checkNotEmpty((String)tag, (String)("affectedTag must not be null or empty, affectedTags = " + affectedTags));
        }
        this.affectedTables = Collections.unmodifiableSet(affectedTables);
        this.affectedTags = Collections.unmodifiableSet(affectedTags);
    }

    @NonNull
    public static Changes newInstance(@NonNull Set<String> affectedTables, @Nullable Collection<String> affectedTags) {
        return new Changes(affectedTables, InternalQueries.nonNullSet(affectedTags));
    }

    @NonNull
    public static Changes newInstance(@NonNull Set<String> affectedTables, String ... affectedTags) {
        return new Changes(affectedTables, InternalQueries.nonNullSet((String[])affectedTags));
    }

    @NonNull
    public static Changes newInstance(@NonNull String affectedTable, @Nullable Collection<String> affectedTags) {
        Checks.checkNotNull((Object)affectedTable, (String)"Please specify affected table");
        return new Changes(Collections.singleton(affectedTable), InternalQueries.nonNullSet(affectedTags));
    }

    @NonNull
    public static Changes newInstance(@NonNull String affectedTable, String ... affectedTags) {
        Checks.checkNotNull((Object)affectedTable, (String)"Please specify affected table");
        return new Changes(Collections.singleton(affectedTable), InternalQueries.nonNullSet((String[])affectedTags));
    }

    @NonNull
    public Set<String> affectedTables() {
        return this.affectedTables;
    }

    @NonNull
    public Set<String> affectedTags() {
        return this.affectedTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Changes changes = (Changes)o;
        if (!this.affectedTables.equals(changes.affectedTables)) {
            return false;
        }
        return this.affectedTags.equals(changes.affectedTags);
    }

    public int hashCode() {
        int result = this.affectedTables.hashCode();
        result = 31 * result + this.affectedTags.hashCode();
        return result;
    }

    public String toString() {
        return "Changes{affectedTables=" + this.affectedTables + ", affectedTags=" + this.affectedTags + '}';
    }
}

