/*
 * Decompiled with CFR 0.152.
 */
package com.pushtorefresh.storio.sqlite.queries;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.pushtorefresh.storio.internal.Checks;
import com.pushtorefresh.storio.internal.InternalQueries;
import java.util.List;

public final class DeleteQuery {
    @NonNull
    private final String table;
    @NonNull
    private final String where;
    @NonNull
    private final List<String> whereArgs;

    private DeleteQuery(@NonNull String table, @Nullable String where, @Nullable List<String> whereArgs) {
        this.table = table;
        this.where = InternalQueries.nonNullString((String)where);
        this.whereArgs = InternalQueries.unmodifiableNonNullListOfStrings(whereArgs);
    }

    @NonNull
    public String table() {
        return this.table;
    }

    @NonNull
    public String where() {
        return this.where;
    }

    @NonNull
    public List<String> whereArgs() {
        return this.whereArgs;
    }

    @NonNull
    public CompleteBuilder toBuilder() {
        return new CompleteBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteQuery that = (DeleteQuery)o;
        if (!this.table.equals(that.table)) {
            return false;
        }
        if (!this.where.equals(that.where)) {
            return false;
        }
        return this.whereArgs.equals(that.whereArgs);
    }

    public int hashCode() {
        int result = this.table.hashCode();
        result = 31 * result + this.where.hashCode();
        result = 31 * result + this.whereArgs.hashCode();
        return result;
    }

    public String toString() {
        return "DeleteQuery{table='" + this.table + '\'' + ", where='" + this.where + '\'' + ", whereArgs=" + this.whereArgs + '}';
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class CompleteBuilder {
        @NonNull
        private String table;
        @Nullable
        private String where;
        @Nullable
        private List<String> whereArgs;

        CompleteBuilder(@NonNull String table) {
            this.table = table;
        }

        CompleteBuilder(@NonNull DeleteQuery deleteQuery) {
            this.table = deleteQuery.table;
            this.where = deleteQuery.where;
            this.whereArgs = deleteQuery.whereArgs;
        }

        @NonNull
        public CompleteBuilder table(@NonNull String table) {
            Checks.checkNotEmpty((String)table, (String)"Table name is null or empty");
            this.table = table;
            return this;
        }

        @NonNull
        public CompleteBuilder where(@Nullable String where) {
            this.where = where;
            return this;
        }

        @NonNull
        public <T> CompleteBuilder whereArgs(T ... whereArgs) {
            this.whereArgs = InternalQueries.unmodifiableNonNullListOfStrings((Object[])whereArgs);
            return this;
        }

        @NonNull
        public DeleteQuery build() {
            if (this.where == null && this.whereArgs != null && !this.whereArgs.isEmpty()) {
                throw new IllegalStateException("You can not use whereArgs without where clause");
            }
            return new DeleteQuery(this.table, this.where, this.whereArgs);
        }
    }

    public static final class Builder {
        Builder() {
        }

        @NonNull
        public CompleteBuilder table(@NonNull String table) {
            Checks.checkNotEmpty((String)table, (String)"Table name is null or empty");
            return new CompleteBuilder(table);
        }
    }
}

